<?php
/**
 * Class represents records from table aff_lead
 * {autogenerated}
 * @property int $lead_id 
 * @property int $aff_id 
 * @property int $user_id 
 * @property datetime $time 
 * @property int $banner_id 
 * @property string $remote_addr 
 * @property string $referrer 
 * @property date $first_visited
 * @see Am_Table
 */
class AffLead extends Am_Record 
{
}

class AffLeadTable extends Am_Table 
{
    protected $_key = 'lead_id';
    protected $_table = '?_aff_lead';
    
    public function insert(array $values, $returnInserted = false)
    {
        if (empty($values['time']))
            $values['time'] = $this->getDi()->sqlDateTime;
        return parent::insert($values, $returnInserted);
    }
    
    function log($aff_id, $banner_id, $user_id, $aff_click_id = null)
    {
        $click = $this->getDi()->affClickTable->load($aff_click_id, false);
        if ($click)
        {
            $referer = $click->referer;
            $first_visited = $click->time;
            $keyword_id = $click->keyword_id;
        } else {
            $referer = null;
            $first_visited = null;
            $keyword_id = null;
        }
        $this->_db->query("INSERT INTO $this->_table
            SET aff_id=?d, 
            user_id=?, time=?, banner_id=?,
            remote_addr=?, referer=?, first_visited=?, keyword_id=?
            ", $aff_id, $user_id, 
            $this->getDi()->sqlDateTime,
            $banner_id, 
            $_SERVER['REMOTE_ADDR'], $referer, $first_visited, $keyword_id);
    }
}
