<?php

function _amemberAfterUpgrade($controller)
{
    $store = Am_Di::getInstance()->store;
    if ($store->get('AM_UPGRADE_REQUIRES_RENAME_V6') < 3) // will be set to 2 after conversion
        $store->set('AM_UPGRADE_REQUIRES_RENAME_V6', 3);
    $store->set('upgrade_finished', $store->get('upgrade_started') ? : '@AM_VERSION@');
    $store->delete('upgrade_started');

    if (version_compare(AM_VERSION, '5.2.4') > 0) {
       return; //skip
    }
    $controller->getSession()->step = $controller->getSession()->step + 1;
    header("Location:".REL_ROOT_URL . "/admin-upgrade");
    exit();
}

function _amemberBeforeUpgrade($controller, $connector, $upgrade = null)
{
    // fix for 6.0.x - make folder plugins/misc not empty!
    if ($connector && preg_match('#^6\.0\.#', AM_VERSION ))
    {
        if ($connector instanceof Am_FileConnector_Ftp)
        {
            $connector->mkdir("application/default/plugins/misc");
            $connector->put(
                __DIR__."/application/default/plugins/misc/thanks-redirect.php",
                "application/default/plugins/misc/thanks-redirect.php");
            $connector->mkdir("application/default/plugins/payment");
            $connector->put(
                __DIR__."/application/default/plugins/payment/paypal.php",
                "application/default/plugins/payment/paypal.php");
            $connector->mkdir("application/default/plugins/protect");
            $connector->put(
                __DIR__."/application/default/plugins/protect/new-rewrite.php",
                "application/default/plugins/protect/new-rewrite.php");
        }
    }

    // keep filelist for future reference
    $store = Am_Di::getInstance()->store;
    $store->set('upgrade_started_from', AM_VERSION);
    $store->set('upgrade_started', '@AM_VERSION@');
    //
    $hashList = json_encode(_am_get_files_md5(Am_Di::getInstance()->root_dir));
    $store->setBlob('before_upgrade_files', $hashList);
    $store->setBlob('before_upgrade_files-'.AM_VERSION.'-@AM_VERSION@' , $hashList);
    if ($upgrade && !empty($upgrade->dir))
    {
        $store->setBlob('upgrade_files', json_encode(_am_get_files_md5($upgrade->dir . '/amember')));
    }
}

function _am_get_files_md5($root)
{
    $hashList = [];
    foreach ($it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($root . '/application')) as $info)
    {
        if (is_file($info->getPathname()))
            $hashList['application/' . $it->getSubPathname()] = md5_file($it->getPathname());
    }
    foreach ($it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($root . '/library')) as $info)
    {
        if (is_file($info->getPathname()))
            $hashList['library/'.$it->getSubPathname()] = md5_file($it->getPathname());
    }
    foreach ($it = new DirectoryIterator($root) as $info)
    {
        if (is_file($info->getPathname()))
            $hashList[$it->getFilename()] = md5_file($it->getPathname());
    }
    return $hashList;
}