<?php

/**
 * Class represents records from table helpdesk_faq
 * {autogenerated}
 * @property int $faq_id
 * @property string $category
 * @property string $title
 * @property string $content
 * @see Am_Table
 */
class HelpdeskFaq extends Am_Record
{
    public function insert($reload = true)
    {
        $table_name = $this->getTable()->getName();
        $max = $this->getAdapter()->selectCell("SELECT MAX(sort_order) FROM {$table_name}");
        $this->sort_order = $max + 1;
        return parent::insert($reload);
    }

    public function delete()
    {
        $ret = parent::delete();
        $table_name = $this->getTable()->getName();
        $this->getAdapter()->query("UPDATE {$table_name}
            SET sort_order=sort_order-1
            WHERE sort_order>?", $this->sort_order);
        return $ret;
    }
}

class HelpdeskFaqTable extends Am_Table
{
    protected $_key = 'faq_id';
    protected $_table = '?_helpdesk_faq';
    protected $_recordClass = 'HelpdeskFaq';
}